////////////////////////////////////////////////////////////////////////////////
//////// lwcate -  Locally-Weighted Conditional Average Treatment Effects //////
//////////////////////////   Version 0.1   /////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

//////////////////// Matthew Robson, September 2019 ////////////////////////////

// This code is the first beta version, so is a work in progress. Please see  //
// https://mrobson92.com/code/ for the newest version of the code and the     //
// help file, which documents the syntax, options and gives examples of how   //
// use the code. Any requests, bugs or need for clarification please email:	  //
// matthew.robson@york.ac.uk 												  //


capture program drop lwcate
program define lwcate , rclass

	syntax anything [if] , Xtilde(string) [XSTRAT(string) EXOPtions(string) Quantiles(real 100) S(real 10) Bandwidth(real 10000) KWeight(string) KBandwidth(real 0.1) Running(string) vce(string) GMINx(real 1) GMAXx(real 0) minx(real 0) maxx(real 1) BSIter(real 200) GTitle(string) GSave(string) GXaxis(string) OBlinder(string) OBEXclusion(string) OBCutoff(real 50) BVar(string) ESTimation(string) POLYdegree(real 3) PRediction(string) NODRAW] 
	
  quietly { //Shh!  

  set type double //Issues with double. This may slow things down...

  
  //Create Equation from Input 
  local splitat = strpos("`0'", ",")
  local splitatif = strpos("`0'", " if ")

  if (`splitatif' == 0){ //If there are no if statements
  local equation = substr("`0'",1, `splitat' - 1)
  local ifstatement = ""
  }
  
  if (`splitatif' > 0){ //If there are if statements
  local equation = substr("`0'" , 1 , `splitatif' - 1)
  local ifstatement = substr("`0'",`splitatif' + 3, `splitat'  - `splitatif' -3)
  local ifstatement = " & " + "`ifstatement'"
  }
  

  //Identify String Components of Regression
  local eqcomm = word("`equation'",1)
  local eqvars: list equation - eqcomm
  local depvar = word("`eqvars'",1)
  local indepvars: list eqvars - depvar
  local treatvar = word("`indepvars'",1)
   
  //Drop Variables 
  local dropvarstemp IndEst_* IndSE_* cons
  foreach z of local dropvarstemp{
        capture drop `z'
 }
 
  //Need to create a running variable, if it is not included 
   tempvar TempNoRunning Strat_`xstrat'
 if ("`running'" == ""){
 gen `TempNoRunning' = 0
 local running `TempNoRunning'
  }
  
 
 /// Specify Variables for Stratified Analysis if XSTRAT is specified
  if "`xstrat'" == "" {
  local TempStratNum =  1
 }
 
if "`xstrat'" != "" {
 tabulate `xstrat', gen(`Strat_`xstrat'')
 local TempStratNum =  r(r)
}

 //Save Temporary Data to Decrease Computational Burden, When Using IF Statements
 tempvar TempUniqueID
 gen `TempUniqueID' = _n
 tempfile TemporaryData
 save `TemporaryData'
 
 /// Run Loop for Stratified Analysis if XSTRAT is specified
 forvalues istrat = 1(1)`TempStratNum' {
	if "`xstrat'" != "" {
		use `TemporaryData' , clear
		keep if `Strat_`xstrat''`istrat' == 1 //Drop all data, which is not within this strata
	}	
 
 	if "`TempStratNum'" == "1" {
	local istrat = ""
	}

 
 *Identify and Drop Observations Excluded by IF or IN, those with missing variables, and for RDD those outside the bandwidth
 	tempvar touse
	mark `touse' `if' 
	markout `touse' `eqvars' `xtilde' `running'
	
	sum `touse'
	if r(mean) == 0 error 2000 //Error Message: If there are No Observations
	 
	keep if abs(`running') <= `bandwidth' & `touse'
	
	
  //Save the Treatment And Running Variables
  tempvar CFObvsTemp CFRunTemp Predict_`depvar' PredictSE_`depvar' CF_T_`depvar' CF_C_`depvar' CF_Diff_`depvar' CFSE_T_`depvar' CFSE_C_`depvar' CFLCI_T_`depvar' CFUCI_T_`depvar' CFLCI_C_`depvar' CFUCI_C_`depvar' CATE_`depvar'
  gen `CFObvsTemp' = `treatvar' //Temporarily Save The Treatment Variable
  gen `CFRunTemp' = `running' //Temporarily Save The Running Variable
  gen `Predict_`depvar'' = .
  gen `PredictSE_`depvar'' = .
  gen `CF_T_`depvar'' = .
  gen `CF_C_`depvar'' = .
  gen `CFSE_T_`depvar'' = .
  gen `CFSE_C_`depvar'' = .
  gen `CFLCI_T_`depvar'' = .
  gen `CFUCI_T_`depvar'' = . 
  gen `CFLCI_C_`depvar'' = .
  gen `CFUCI_C_`depvar'' = . 
  gen `CATE_`depvar'' = .
  
  //For "both" prediction graph
  if strpos("`prediction'", "both") > 0 { 
  tempvar MeanCF_T MeanCF_C MeanCFSE_T MeanCFSE_C MeanCFLCI_T MeanCFUCI_T MeanCFLCI_C MeanCFUCI_C
  gen `MeanCF_T' = .
  gen `MeanCF_C' = .
  gen `MeanCFSE_T' = .
  gen `MeanCFSE_C' = .
  gen `MeanCFLCI_T' = .
  gen `MeanCFUCI_T' = . 
  gen `MeanCFLCI_C' = .
  gen `MeanCFUCI_C' = . 
  }
  
  //For Differing KWeights
  if ("`kweight'" == "") {
  local kweight beta 
  }

  //For Oaxaca we need to create additional string variables to estimate the component effects
  if ("`oblinder'" != ""){
  local obdepvars: list indepvars - obexclusion 
  local totalcoefficient
  local totalendowments
  local totaldecompnames
  foreach z of local obdepvars{
    local totalcoefficient =  "`totalcoefficient'" + "[Unexplained]" + "`z'" + " + "
    local totalendowments =  "`totalendowments'" + "[Explained]" + "`z'" + " + "
    local totaldecompnames =  "`totaldecompnames'" + "Unexplained:" + "`z' " 
    local totaldecompnames =  "`totaldecompnames'" + "Explained:" + "`z' " 
	}
  local totalcoefficient = substr("`totalcoefficient'", 1,  length("`totalcoefficient'") - 3)
  local totalendowments = substr("`totalendowments'", 1,  length("`totalendowments'") - 3)
  local totaldecomp = "`totalcoefficient'" + " + " + "`totalendowments'" + " + " + "[Unexplained]_cons"
  local totaldecompnames =  "`totaldecompnames'" + "Unexplained:_cons"

  tempname OBResults TempResults

  matrix `OBResults' = J(`quantiles' , 8,.)
  matrix colnames `OBResults' = Total_B Total_SE Endowment_B Endowment_SE Coefficient_B Coefficient_SE Unexplained_B Unexplained_SE 
  }
   
   
   ///// Multidimensional Loop here....
   tempvar Weight
	gen `Weight' = 1
	
   foreach jj of local xtilde {
   local x `jj'
   
   
  //Create Ranks
  *1) Create Unique Ranks
  *2) Find where ranks are not unique
  *3) For those who don't have unique ranks, their weight is the integral of the pdf between all those duplicates, divided by the number of duplicates (see upper and lower below..)
  tempvar Rank_`x' CountEqRank_`x' TempRank_Max_`x' Ave_`x'_Quantile SWRank_`x' CountSWEqRank_`x' SWAve_`x'_Quantile Ave_`x'_PMean `x'_Q_Count 
  
  egen `Rank_`x'' = rank(`x') , track
  bysort  `Rank_`x'': egen `CountEqRank_`x'' = count(`Rank_`x'') 
  replace `Rank_`x'' = `Rank_`x'' + (`CountEqRank_`x'' - 1)/2 

  gen `TempRank_Max_`x'' = `Rank_`x'' + (`CountEqRank_`x'' - 1)/2 
  sum `TempRank_Max_`x''
  local MaxRank = r(max) 
  drop `TempRank_Max_`x''
  
  gen `Ave_`x'_Quantile' = (`Rank_`x'' - 0.5) / `MaxRank'

  egen `SWRank_`x'' = rank(`x') , field
  bysort  `SWRank_`x'': egen `CountSWEqRank_`x'' = count(`SWRank_`x'') 
  replace `SWRank_`x'' = `SWRank_`x'' + (`CountSWEqRank_`x'' - 1)/2 

  gen `TempRank_Max_`x'' = `SWRank_`x'' + (`CountSWEqRank_`x'' - 1)/2 
  sum `TempRank_Max_`x''
  local SWMaxRank = r(max) 
  drop `TempRank_Max_`x''

  gen `SWAve_`x'_Quantile' = (`SWRank_`x'' - 0.5) / `SWMaxRank'

  bysort `Ave_`x'_Quantile': egen `Ave_`x'_PMean' = mean(`x') 
  bysort `Ave_`x'_Quantile': egen ``x'_Q_Count' = count(`Ave_`x'_Quantile') 


   //Create Bootstrapped Weights if VCE = bootstrap
	if ("`vce'" == "bootstrap"){
	*Identify Missing Data
		
	/*
	*By Hand BWs
	quietly egen BSampleCount = sum(nonmiss) 
	
	di "Bootstrap Weights with `bsiter' repititions"
	set seed 1234
	forvalues j = 1(1)`bsiter' {
	capture drop fw`j'
	quietly generate fw`j' = .
	quietly bsample BSampleCount -1 if nonmiss == 1, weight(fw`j')
	egen bstemp = mean(fw`j')
	
	replace fw`j' = 
	di "." _cont
	if (mod(`j' / 50, 1) == 0 ) {
	di "`j'"
	}	
	}
	*/
	
	}
	
  tempvar `x'_star `x'_alpha `x'_beta `x'_Weight `x'_WeightSum Upper_`x'_Quantile Lower_`x'_Quantile Mid_`x'_Quantile SWUp_`x'_Quan SWLow_`x'_Quan
  gen ``x'_star' = . 
  gen ``x'_alpha' = .
  gen ``x'_beta' = .
  gen ``x'_Weight' = .

  //Rerun from here for different s (precision)
  tempname TResults Results TResults0 Weights
  set matsize 1000
  matrix `Results' = J(`quantiles' , 11,.)
  matrix colnames `Results' = Quan EQuan EQuanAve B SE PVal N RSq MSE SAlpha SBeta 
  local min = (1/`quantiles')/2
  local max = 1-`min'
  local step = 1/`quantiles'
  
  
  //Generate the Upper and Lower bounds, which surround the quantile of the individual, and enable the weight to be calculated
  gen `Upper_`x'_Quantile' = round(`Ave_`x'_Quantile' + ((`CountEqRank_`x''/`MaxRank')/2), 1/`MaxRank')
  gen `Lower_`x'_Quantile' = round(`Ave_`x'_Quantile' - ((`CountEqRank_`x''/`MaxRank')/2), 1/`MaxRank')
  gen `Mid_`x'_Quantile' = (`Lower_`x'_Quantile' + `Upper_`x'_Quantile') / 2
  
  //Create these to deal with issue of ibeta command
  gen `SWUp_`x'_Quan' = round(`SWAve_`x'_Quantile' + ((`CountSWEqRank_`x''/`SWMaxRank')/2), 1/`SWMaxRank')
  gen `SWLow_`x'_Quan' = round(`SWAve_`x'_Quantile' - ((`CountSWEqRank_`x''/`SWMaxRank')/2), 1/`SWMaxRank')

  // Allow for User Input Max and Mins
  if (`minx' > `min'){
  local min = `minx'
  }
  if (`maxx' < `max'){
  local max = `maxx'
  }

   
  } //End of 1st MD Loop
  
   local max = `max' + `step'
   local ii=0
   noisily di ""
   noisily di "Running for `quantiles' Quantiles, follow the dots..."

   
  ////// Main Loop
  forvalues i = `min'(`step')`max' {
  local ii= `ii' + 1

  if `ii' > `quantiles' {
  continue //Failsafe for small no.s of quantiles
  }
  
  noisily {
  di "." _cont
	if (mod(`ii' / 20, 1) == 0 ) {
	di "`ii'"
	}	
	}
  
  //Create the Weights for the regression, through specifying the quantile of interest (x_star), calculating alpha and beta, then given these, the weights from the resulting Beta pdf. 
  replace ``x'_star' = `i' 
  capture drop ``x'_WeightSum'

  **Uniform Weights: 1 if x_star - h/2 <= x_i <= x_star + h/2; 0 otherwise
    if ("`kweight'" == "uniform") {
	replace ``x'_Weight' = 1 if (`Mid_`x'_Quantile' >= ``x'_star' - (`kbandwidth' /2)  & `Mid_`x'_Quantile' <= ``x'_star' + (`kbandwidth' /2)) 
    replace ``x'_Weight' = 0 if (`Mid_`x'_Quantile' < ``x'_star' - (`kbandwidth' /2)  |  `Mid_`x'_Quantile' > ``x'_star' + (`kbandwidth' /2)) 
    egen ``x'_WeightSum' = sum(``x'_Weight') 
	replace ``x'_Weight' = ``x'_Weight' / ``x'_WeightSum'
	}
	
  **Triangular Weights: 3/4 * (1 - ((x_star - x_i)/ (h/2))^2)
    if ("`kweight'" == "triangular") {
	replace ``x'_Weight' = 1 - (abs(``x'_star' - `Mid_`x'_Quantile') / (`kbandwidth' /2)) if (`Mid_`x'_Quantile' >= ``x'_star' - (`kbandwidth' /2)  & `Mid_`x'_Quantile' <= ``x'_star' + (`kbandwidth' /2))
    replace ``x'_Weight' = 0 if (`Mid_`x'_Quantile' < ``x'_star' - (`kbandwidth' /2)  |  `Mid_`x'_Quantile' > ``x'_star' + (`kbandwidth' /2))
    egen ``x'_WeightSum' = sum(``x'_Weight')  
	replace ``x'_Weight' = ``x'_Weight' / ``x'_WeightSum'
	}
  
  **Normal Weights: PDF(x_i) of N ~ (x_star, SD(h)) 
   if ("`kweight'" == "normal") {
    sum  `Mid_`x'_Quantile' if (`Mid_`x'_Quantile' >= ``x'_star' - (`kbandwidth' /2)  & `Mid_`x'_Quantile' <= ``x'_star' + (`kbandwidth' /2)) 
    local SD_Norm = r(sd) //Generate a Standard Deviation for the individuals within the bandwidth, this SD will be input into the normal density function below, centred on x_star. 
      
	replace ``x'_Weight' = normalden(`Mid_`x'_Quantile', ``x'_star', `SD_Norm') 
	egen ``x'_WeightSum' = sum(``x'_Weight')  
	replace ``x'_Weight' = ``x'_Weight' / ``x'_WeightSum'
   }

  **Epanechnikov Weights: 3/4 * (1 - ((x_star - x_i)/ (h/2))^2)
  if ("`kweight'" == "epanechnikov") {
	replace ``x'_Weight' = (3/4) * ( 1 - (((``x'_star' - `Mid_`x'_Quantile' ) / (`kbandwidth' /2))^2)) if  (`Mid_`x'_Quantile' >= ``x'_star' - (`kbandwidth' /2)  & `Mid_`x'_Quantile' <= ``x'_star' + (`kbandwidth' /2)) & abs(`running') <= `bandwidth' `ifstatement' & `x' != .
    replace ``x'_Weight' = 0 if (`Mid_`x'_Quantile' < ``x'_star' - (`kbandwidth' /2)  |  `Mid_`x'_Quantile' > ``x'_star' + (`kbandwidth' /2)) 
	egen ``x'_WeightSum' = sum(``x'_Weight')  
	replace ``x'_Weight' = ``x'_Weight' / ``x'_WeightSum'
  }
    
  **Beta Distribution Weights (Perhaps normalise s so that s \in 0, 1)
  if ("`kweight'" == "beta") {
  
  *local s = (2* `kbandwidth' ^ 0.2 - 3) / (`kbandwidth' ^ 0.2 - 1) //Use this if we want to input h instead of s, this transforms h (bounded between 0 and 1) to reasonable values of s (0 = 3, 0.5 -> 10, -> 1 -> inf)
  
  if ("`bvar'" == ""){
  replace ``x'_alpha' = ``x'_star' * (`s' - 1) if abs(`running') <= `bandwidth' `ifstatement' & `x' != .
  replace  ``x'_beta' = (1-``x'_star') * (`s' - 1) if abs(`running') <= `bandwidth' `ifstatement' & `x' != .
  }
  
  if ("`bvar'" == "constant"){
  replace ``x'_alpha' = ``x'_star' * (``x'_star' * ((1-``x'_star')/`s') -1 ) if abs(`running') <= `bandwidth' `ifstatement' & `x' != .
  replace  ``x'_beta' = (``x'_star' * ((1-``x'_star')/`s') - 1 ) * (1- ``x'_star')  if abs(`running') <= `bandwidth' `ifstatement' & `x' != .
  }

  if (``x'_star' >= 0.5 ) {
	replace ``x'_Weight' = ( ibeta(``x'_alpha', ``x'_beta', `Upper_`x'_Quantile') - ibeta(``x'_alpha', ``x'_beta', `Lower_`x'_Quantile')) / `CountEqRank_`x'' //Weights from the Beta PDF, for each individual, given the shape parameters: alpha and beta. 
  }
 // Issue with ibeta command, not symmetric as it should be. For high alpha and low beta it gives high x a zero, while for low alpha and high beta low x does not get a zero... 
 if (``x'_star' < 0.5 ) {
	replace ``x'_Weight' = ( ibeta(``x'_beta', ``x'_alpha', `SWUp_`x'_Quan') - ibeta(``x'_beta', ``x'_alpha', `SWLow_`x'_Quan')) / `CountSWEqRank_`x''   //Weights from the Beta PDF, for each individual, given the shape parameters: alpha and beta. 
 }
 egen ``x'_WeightSum' = sum(``x'_Weight')  //Generate the Sum (Should be 1)
  }
  
  **Discrete Weights: 1 if x_star is within the discrete catagory bounds, 0 otherwise
  if ("`kweight'" == "discrete") {
	replace ``x'_Weight' = 1 if (``x'_star' >= `Lower_`x'_Quantile' & ``x'_star' <= `Upper_`x'_Quantile' ) 
    replace ``x'_Weight' = 0 if (``x'_star' < `Lower_`x'_Quantile' | ``x'_star' > `Upper_`x'_Quantile' ) 
    egen ``x'_WeightSum' = sum(``x'_Weight')  
	replace ``x'_Weight' = ``x'_Weight' / ``x'_WeightSum'
	}
  
   replace `Weight' =  ``x'_Weight'
  
  tempvar Weight_`ii'
  
  gen `Weight_`ii'' = `Weight' //Record All Weights

       sum `Ave_`x'_Quantile' [aw=`Weight'] //Shows the Expected Quantile according to the pweights
	   matrix `TResults0' = r(mean)
   	   matrix `Results'[`ii',2] = `TResults0'[1,1]	 //Expected Percentile

       sum `Ave_`x'_PMean' [aw=`Weight'] //Shows the Expected `x' within each Quantile according to the pweights
	   matrix `TResults0' = r(mean)
   	   matrix `Results'[`ii',3] = `TResults0'[1,1]	 //Expected Quantile Average `x' within each Quantile

 if ("`oblinder'" != ""){
 `equation' [aw=`Weight'] , `oblinder' //Main Regression
}
		
if ("`oblinder'" == ""){
if ("`vce'" == "bootstrap"){
 *Bootstrap Weights are calulated with bsweights, then svy runs the bootstrap regression
 capture bsweights bw, reps(`bsiter') n(-1) seed(10101) dots balanced replace nosvy
 svyset [pw=`Weight'], vce(bootstrap) bsrweight(bw*)
 svy: `equation'  //Main Bootstrap Regression

*Alternative..
*bs4rw, rweights(bw*): `equation' [aw=`Weight']
 }
	
if ("`vce'" != "bootstrap"){

///// CHANGE THIS TO WEIGHTED EXPECTATION OF GROUP, NOT SIMPLE MEAN

// For Local-Linear Regression
if ("`estimation'" == "linear" | "`estimation'" == "linearint" | "`estimation'" == "poly" | "`estimation'" == "polyint"){
local LTemp LL_`x'

capture drop LL_`x' LL_Temp
sum `x'  if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) //Find the mean of x, within the quantile of interest
gen LL_Temp = r(mean)
gen LL_`x' = `x' - LL_Temp //Generate a variable which is the difference from that mean value of x
if ("`estimation'" == "linear"){
local equation: list equation - LTemp
local equation `equation' LL_`x' //Add the local linear variable to the regression equation
}
if ("`estimation'" == "linearint"){
local LTemp2 LL_`x' c.LL_`x'#`treatvar'
local equation: list equation - LTemp2
local equation `equation' LL_`x' c.LL_`x'#`treatvar' //Add the local linear variable to the regression equation and interect it with the treatment dummy
}

if ("`estimation'" == "poly"){
local LTemp3 `PolyTemp'
local equation: list equation - LTemp3

local PolyTemp c.LL_`x'
forvalues pp = 2(1)`polydegree' {
local PolyTemp `PolyTemp'##c.LL_`x'
}

local equation `equation' `PolyTemp' //Add the local linear variable to the regression equation
}

if ("`estimation'" == "polyint"){
local LTemp3 `PolyTemp'
local equation: list equation - LTemp3

local PolyTemp c.LL_`x'
forvalues pp = 2(1)`polydegree' {
local PolyTemp `PolyTemp'##c.LL_`x'
}
local PolyTemp `PolyTemp'#`treatvar'

local equation `equation' `PolyTemp' //Add the local linear variable to the regression equation
}
}

//Main Regression (rather undewhelming isn't it...)
        `equation' [pw=`Weight'] ,  vce(`vce') `exoptions'
 }
 }
 
	*CHANGE HERE FOR ALTERNATIVE STATISTICS, ESPECIALLY WITH ALTERNATIVE REGRESSION COMMANDS
	
  		matrix `TResults' = r(table)
        local Temp_Colnames : colfullnames `TResults' 
		if ("`eqcomm'" == "logit" | "`eqcomm'" == "probit" | "`eqcomm'" == "nbreg"){
		local Temp_Colnames : colnames `TResults' //Logit and Probit colfullnames have "YVar:" preculding the X, so we need to remove that
		}
		if ("`eqcomm'" == "tobit"){
		local Temp_Colnames : colnames `TResults' 
		local Temp_TEnd = word("`Temp_Colnames'",-1)
		local Temp_Colnames = substr("`Temp_Colnames'",1,length("`Temp_Colnames'") - length("`Temp_TEnd'") - 1)
		}
		local TreatCol = 1
		if substr("`Temp_Colnames'",1,3) == "0b." {
		local TreatCol = 2 //In case an interaction term has been used, the first variable 0b.Treatment will correspond to when Treatment = 0, so all coefficients will be 0, so we want the results for 1.Treatment
		}
		matrix `Results'[`ii',1] = `i' // Percentile of Interest
		matrix `Results'[`ii',4] = `TResults'[1,`TreatCol'] //Beta for Treatment Effect
		matrix `Results'[`ii',5] = `TResults'[2,`TreatCol'] //SE for Treatment Effect
		matrix `Results'[`ii',6] = `TResults'[4,`TreatCol'] //P Value
	    matrix `Results'[`ii',7] = e(N) //N
		matrix `Results'[`ii',8] = e(r2)	 //R2
		matrix `Results'[`ii',9] = e(rmse)^2  //Mean Squared Error
		matrix `Results'[`ii',10] = ``x'_alpha'[1] //Shape Alpha
		matrix `Results'[`ii',11] = ``x'_beta'[1]  //Shape Beta


    *Create Matrix of Coefficients for All Variables
	*tempname Beta_Matrix SE_Matrix PVal_Matrix
	
	   if (`ii' == 1){
	   matrix Beta_Matrix = J(`quantiles' , colsof(`TResults'),.)
	   matrix colnames Beta_Matrix = `Temp_Colnames'
	   matrix SE_Matrix = J(`quantiles' , colsof(`TResults'),.)
	   matrix colnames SE_Matrix = `Temp_Colnames'
	   matrix PVal_Matrix = J(`quantiles' , colsof(`TResults'),.)
	   matrix colnames PVal_Matrix = `Temp_Colnames'
	   }
	   
	   matrix Beta_Matrix[`ii',1] = `TResults'[1,1...]  // Beta Coeffients 
	   matrix SE_Matrix[`ii',1] = `TResults'[2,1...]    // Standard Errors 
	   matrix PVal_Matrix[`ii',1] = `TResults'[4,1...]  // P-Values 

		*Results For OB Decompositions	
		if ("`oblinder'" != ""){
		//Use Lincom to Identify the Total Component Effects, excluding variables not of interest (e.g. in RDD: time interactions)
		lincom `totalendowments'
		matrix `OBResults'[`ii',3] = r(estimate)
		matrix `OBResults'[`ii',4] = r(se)
		lincom `totalcoefficient'
		matrix `OBResults'[`ii',5] = r(estimate)
		matrix `OBResults'[`ii',6] = r(se)
		lincom [Unexplained]_cons
		matrix `OBResults'[`ii',7] = r(estimate)
		matrix `OBResults'[`ii',8] = r(se)
		lincomest `totaldecomp' //Here use the lincomest to allow us to extract p-values
		matrix `TempResults' = r(table)
		matrix `OBResults'[`ii',1] = `TempResults'[1,1]
		matrix `OBResults'[`ii',2] = `TempResults'[2,1]
		*Replace the Results in Results
		matrix `Results'[`ii',4] = `TempResults'[1,1] //Beta for Treatment Effect
		matrix `Results'[`ii',5] = `TempResults'[2,1] //SE for Treatment Effect
		matrix `Results'[`ii',6] = `TempResults'[4,1] //P Value
		}

		
		if ("`oblinder'" == ""){
		
		//Predictions
		local PredOpt
		if ("`eqcomm'" == "tobit"){
		local PredOpt ", ystar(0,.)"
		}
		
		tempvar CFTemp CFSETemp CFXBTemp CFLCITemp CFUCITemp
		
		predict `CFTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) `PredOpt' 
		replace `Predict_`depvar'' = `CFTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		predict `CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2), stdp
		replace `PredictSE_`depvar'' = `CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		drop `CFTemp' `CFSETemp'


		///Counterfactual Treatment Predictions
   		replace `running' = 0 //Predictions at Running = 0
		
		///Mean Counterfactuals [A Better Solution for Both. Find the means of all vars, then replace the vars with that, then predict]
		*foreach mx of local indepvars {
		*sum `mx' [aweight = `Weight']
		*local WMean_`mx' = r(mean)
		*if "`mx'" == "`running'" {
		*local WMean_`mx' = 0
		*}
		*}
		
		
		//Counterfactual of being in the Treated group
		replace `treatvar' = 1 
		predict `CFTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) `PredOpt'
		replace `CF_T_`depvar'' = `CFTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
	    predict `CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2), stdp
		replace `CFSE_T_`depvar'' = `CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		
		//For "both" Graphs, predicting atmeans
		if strpos("`prediction'", "both") > 0 {
		margins `treatvar' , atmeans predict(xb) 
		matrix TempMeanTable = r(table)  
		replace `MeanCF_T' = TempMeanTable[1,1] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `MeanCFLCI_T' = TempMeanTable[5,1] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `MeanCFUCI_T' = TempMeanTable[6,1] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		}
		
		
		if ("`eqcomm'" == "regress" | "`eqcomm'" == "reg"){ //95% CIs for OLS
		replace `CFLCI_T_`depvar'' = `CFTemp' - (`CFSETemp' * 1.96) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_T_`depvar'' = `CFTemp' + (`CFSETemp' * 1.96) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		}
		
		if ("`eqcomm'" == "tobit"){ //95% CIs for Tobit (WRONG)
		predictnl `CFXBTemp' = predict(ystar(0,.)) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) , ci(`CFLCITemp' `CFUCITemp')
		replace `CFLCI_T_`depvar'' = `CFLCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_T_`depvar'' = `CFUCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		drop `CFXBTemp' `CFLCITemp' `CFUCITemp'
		}
		
		if ("`eqcomm'" == "nbreg"){ //95% CIs for Negative Binomial Regression
		predictnl `CFXBTemp' = predict(n) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) , ci(`CFLCITemp' `CFUCITemp')
		replace `CFLCI_T_`depvar'' = `CFLCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_T_`depvar'' = `CFUCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		drop `CFXBTemp' `CFLCITemp' `CFUCITemp'
		}
		
		if ("`eqcomm'" == "logit" | "`eqcomm'" == "probit"){ //Logits and Probits need specific calculations for 95% CIs
		predict `CFXBTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2), xb
		gen `CFLCITemp' = `CFXBTemp' - invnormal(0.975)*`CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		gen `CFUCITemp' = `CFXBTemp' + invnormal(0.975)*`CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		if ("`eqcomm'" == "logit" ){
		replace `CFLCI_T_`depvar'' = invlogit(`CFLCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_T_`depvar'' = invlogit(`CFUCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			if strpos("`prediction'", "both") > 0 {
			replace `MeanCF_T' = invlogit(`MeanCF_T') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFLCI_T' = invlogit(`MeanCFLCI_T') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFUCI_T' = invlogit(`MeanCFUCI_T') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			}
		}
		if ("`eqcomm'" == "probit" ){
		replace `CFLCI_T_`depvar'' = normal(`CFLCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_T_`depvar'' = normal(`CFUCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			if strpos("`prediction'", "both") > 0 {
			replace `MeanCF_T' = normal(`MeanCF_T') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFLCI_T' = normal(`MeanCFLCI_T') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFUCI_T' = normal(`MeanCFUCI_T') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			}
		}
		drop `CFXBTemp' `CFLCITemp' `CFUCITemp'
		}
		
		drop `CFTemp' `CFSETemp'
	

		//Counterfactual of being in the Control group
		replace `treatvar' = 0 
		predict `CFTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)  `PredOpt'
		replace `CF_C_`depvar'' = `CFTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		predict `CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2), stdp
		replace `CFSE_C_`depvar'' = `CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		
		//For "both" Graphs, predicting atmeans
		if strpos("`prediction'", "both") > 0 {
		margins `treatvar' , atmeans predict(xb) 
		matrix TempMeanTable = r(table)  
		replace `MeanCF_C' = TempMeanTable[1,1] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `MeanCFLCI_C' = TempMeanTable[5,1] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `MeanCFUCI_C' = TempMeanTable[6,1] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		}
		
		if ("`eqcomm'" == "regress" | "`eqcomm'" == "reg"){ //95% CIs for OLS
		replace `CFLCI_C_`depvar'' = `CFTemp' - (`CFSETemp' * 1.96) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_C_`depvar'' = `CFTemp' + (`CFSETemp' * 1.96) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		}
		
		if ("`eqcomm'" == "tobit"){ //95% CIs for Tobit
		predictnl `CFXBTemp' = predict(ystar(0,.)) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) , ci(`CFLCITemp' `CFUCITemp')
		replace `CFLCI_C_`depvar'' = `CFLCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_C_`depvar'' = `CFUCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		drop `CFXBTemp' `CFLCITemp' `CFUCITemp'
		}
		
		if ("`eqcomm'" == "nbreg"){ //95% CIs for Negative Binomial Regression
		predictnl `CFXBTemp' = predict(n) if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2) , ci(`CFLCITemp' `CFUCITemp')
		replace `CFLCI_C_`depvar'' = `CFLCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_C_`depvar'' = `CFUCITemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		drop `CFXBTemp' `CFLCITemp' `CFUCITemp'
		}
	
		
		if ("`eqcomm'" == "logit" | "`eqcomm'" == "probit"){ //Logits and Probits need specific calculations for 95% CIs
		predict `CFXBTemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2), xb
		gen `CFLCITemp' = `CFXBTemp' - invnormal(0.975)*`CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		gen `CFUCITemp' = `CFXBTemp' + invnormal(0.975)*`CFSETemp' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		if ("`eqcomm'" == "logit" ){
		replace `CFLCI_C_`depvar'' = invlogit(`CFLCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_C_`depvar'' = invlogit(`CFUCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			if strpos("`prediction'", "both") > 0 {
			replace `MeanCF_C' = invlogit(`MeanCF_C') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFLCI_C' = invlogit(`MeanCFLCI_C') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFUCI_C' = invlogit(`MeanCFUCI_C') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			}
		}
		if ("`eqcomm'" == "probit" ){
		replace `CFLCI_C_`depvar'' = normal(`CFLCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		replace `CFUCI_C_`depvar'' = normal(`CFUCITemp') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			if strpos("`prediction'", "both") > 0 {
			replace `MeanCF_C' = normal(`MeanCF_C') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFLCI_C' = normal(`MeanCFLCI_C') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			replace `MeanCFUCI_C' = normal(`MeanCFUCI_C') if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
			}
		}
		drop `CFXBTemp' `CFLCITemp' `CFUCITemp'
		}
		
		drop `CFTemp' `CFSETemp'
		

		replace `treatvar' = `CFObvsTemp' //Restore Treated Dummy		
		replace `running' = `CFRunTemp' //Restore Running 

		replace `CATE_`depvar'' = `CF_T_`depvar'' - `CF_C_`depvar'' if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)
		
  }
  }

  *matrix list Results
  tempname QSummary OBQSummary
  svmat `Results' , name(`QSummary')

*Confidence Intervals
tempvar IPW_LBA IPW_UBA IPW_LBB IPW_UBB IPW_LBC IPW_UBC
quietly gen `IPW_LBA' = `QSummary'4-2.576*`QSummary'5
quietly gen `IPW_UBA' = `QSummary'4+2.576*`QSummary'5
quietly gen `IPW_LBB' = `QSummary'4-1.96*`QSummary'5
quietly gen `IPW_UBB' = `QSummary'4+1.96*`QSummary'5
quietly gen `IPW_LBC' = `QSummary'4-1.645*`QSummary'5
quietly gen `IPW_UBC' = `QSummary'4+1.645*`QSummary'5

*Graph Particulars
local XLabel : var label `x'
local YLabel_Pred : var label `depvar'
if missing("`XLabel'") {
local XLabel = "`x'"
}
if missing("`YLabel_Pred'") {
local YLabel_Pred = "`depvar'"
}
if ("`gxaxis'" == ""){
local XLabel = "`XLabel', Quantile"
local gxinput `QSummary'2
local gxinput_Pred `Mid_`x'_Quantile'
}
if ("`gxaxis'" == "actual"){
local XLabel = "`XLabel'"
local gxinput `QSummary'3
local gxinput_Pred `x'
}

 if ("`kweight'" == "discrete") {
local gxinput `QSummary'1
}

quietly{
if ("`oblinder'" == ""){
*Create Individual-Level Coefficient Estimates, given they belong to the Quantile of Interest Associated with the Coefficients

		local ki = 0
		local IndEst_Names1 //IndEst_Names1 are the Variable Names for the Individual-Level Estimates, which are needed for the predictions later
	    local IndEst_Names2 //IndEst_Names1 are the Variable Names for the Individual-Level Estimates, which will be saved in the data set

		foreach k of local Temp_Colnames {
			local ki= `ki' + 1
			local iii=0

     		local IndEst_Names1 = "`IndEst_Names1'" + "`k' "
			
			local k = subinstr("`k'", ".", "",.) //Remove . as variables names can't include them
			local k = subinstr("`k'", "#", "X",.) //Remove # as variables names can't include them
			local k = substr("`k'", 1, 25) //Have to limit the size so variable names aren't too long (32 Max)
			
			if "`k'" == "_cons" {
			local k = subinstr("`k'", "_", "",.) //Remove _ as variables names can't include them at the start
			}

     		local IndEst_Names2 = "`IndEst_Names2'" + "IndEst_`k' "
			gen IndEst_`k' = .
			gen IndSE_`k' = .

			forvalues i = `min'(`step')`max' {
				local iii= `iii' + 1
				replace IndEst_`k' = Beta_Matrix[`iii', `ki'] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)  //Create Variables which are individual-level estimates, depending on the quantile of interest the individual belongs too.
				replace IndSE_`k' = SE_Matrix[`iii', `ki'] if `Ave_`x'_Quantile' > `i' - (`step'/2) & `Ave_`x'_Quantile' < `i' + (`step'/2)  //Create Variables which are individual-level estimates, depending on the quantile of interest the individual belongs too.
				}
		}

*Create A List of Variables Which Exclude the 0b.Treatment variables, and their interactions
local IndEst_First = word("`IndEst_Names1'",1)
local IndEst_Names1Temp 
local IndEst_Names2Temp 
local kb = 0

if substr("`IndEst_First'",1,3) == "0b." { //Only do this when the treatment variable is precluded by "0b."
		foreach j of local IndEst_Names1 { //Cycle through all words in IndEst_Names1
			local kb= `kb' + 1
			local kbword1 = word("`IndEst_Names1'",`kb')
			local kbword2 = word("`IndEst_Names2'",`kb')

			if strpos("`j'","`IndEst_First'") == 0 { //Loop which allows us to delete any words which include "0b.Treatment", including interactions   
     		local IndEst_Names1Temp = "`IndEst_Names1Temp'" + "`kbword1' "
    		local IndEst_Names2Temp = "`IndEst_Names2Temp'" + "`kbword2' "
			}
}
local IndEst_Names1 = "`IndEst_Names1Temp'" 
local IndEst_Names2 = "`IndEst_Names2Temp'" 
}

local IndEst_NewFirst = word("`IndEst_Names1'",1) //Create A Variable for the Treatment Dummy, which we can then make equal 0 or 1 for CF analysis
if substr("`IndEst_NewFirst'",1,2) == "1." { //Only do this when the treatment variable is precluded by "1."
local IndEst_NewFirst = substr("`IndEst_NewFirst'",3,.)
}

	
gen `CF_Diff_`depvar'' = `CF_T_`depvar'' - `CF_C_`depvar'' //Difference in the Counterfactuals

//Goodness of Fit
tempvar Resid_`depvar' ResidSq_`depvar' RSS_`depvar' Mean_`depvar' TS_`depvar' TSS_`depvar' RSq_`depvar'
gen `Resid_`depvar'' =  `depvar' - `Predict_`depvar''  //Generate the Residuals from the Predicted Model
gen `ResidSq_`depvar'' =  `Resid_`depvar'' * `Resid_`depvar''  //Generate the Squared Residuals from the Predicted Model
egen `RSS_`depvar'' = total(`ResidSq_`depvar'') if `Predict_`depvar'' != . //Residual Sum of Squares
egen `Mean_`depvar'' = mean(`depvar') if `Predict_`depvar'' != . //Mean Y
gen `TS_`depvar'' =  (`depvar' - `Mean_`depvar'')*(`depvar' - `Mean_`depvar'') if `Predict_`depvar'' != . //Total Difference Squared of Y
egen `TSS_`depvar'' = total(`TS_`depvar'') if `Predict_`depvar'' != . //Total Sum of Squares

gen `RSq_`depvar'' = 1 - (`RSS_`depvar'' / `TSS_`depvar'')

sum `RSS_`depvar''
local RSS = round(r(mean),0.0001)
sum `TSS_`depvar''
local TSS = round(r(mean),0.0001)
sum `RSq_`depvar''
local RSq = round(r(mean),0.0001)

//Treatment Effects and Treatment Effects on the Treated
quietly sum `CATE_`depvar'' if `treatvar' == 1 
local ACATET = round(r(mean),0.0001)
quietly sum `CATE_`depvar'' 
local ACATE = round(r(mean),0.0001)
}

//Create Graph of Treatment Effects, Conditional on X
sum `gxinput'
local TempGxmin = round(r(min),0.0001)
local TempGxmax = round(r(max),0.0001)
local GConnect  
if ("`kweight'" == "discrete") {
local GConnect "stairstep" // GConnect allows for a stairstep graph, if the variable is declared as discrete. 
}

if ("`nodraw'" == "") {
if (`gminx' != 1 | `gmaxx' != 0) {
twoway (rarea `IPW_LBA' `IPW_UBA' `gxinput' if `gxinput' > `gminx' & `gxinput' < `gmaxx', bcolor("4 90 141*0.5") alwidth(0) connect(`GConnect')) (rarea `IPW_LBB' `IPW_UBB' `gxinput' if `gxinput' > `gminx' & `gxinput' < `gmaxx', bcolor("4 90 141*0.75") alwidth(0) connect(`GConnect')) (rarea `IPW_LBC' `IPW_UBC' `gxinput' if `gxinput' > `gminx' & `gxinput' < `gmaxx', bcolor("4 90 141") alwidth(0) connect(`GConnect')) (line `QSummary'4 `gxinput' if `gxinput' > `gminx' & `gxinput' < `gmaxx', lcolor(white) connect(`GConnect')) (scatteri 0 `TempGxmin' 0 `TempGxmax', recast(line) lcolor(black) lpattern(dash)) , xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Conditional Average Treatment Effect")  yscale(titlegap(*5)) ylab(, nogrid format(%03.1f) notick) xlab(, nogrid format(%03.1f) notick) title("`gtitle'") graphregion(color(white)) legend(order( 3 "90% CI"  2 "95% CI" 1 "99% CI") row(1) colfirst region(color(white))) name(G`istrat', replace) 
}
if (`gminx' == 1 & `gmaxx' == 0) {
twoway (rarea `IPW_LBA' `IPW_UBA' `gxinput' , bcolor("4 90 141*0.5") alwidth(0) connect(`GConnect')) (rarea `IPW_LBB' `IPW_UBB' `gxinput' , bcolor("4 90 141*0.75") alwidth(0) connect(`GConnect')) (rarea `IPW_LBC' `IPW_UBC' `gxinput' , bcolor("4 90 141") alwidth(0) connect(`GConnect')) (line `QSummary'4 `gxinput', lcolor(white) connect(`GConnect')) (scatteri 0 `TempGxmin' 0 `TempGxmax', recast(line) lcolor(black) lpattern(dash)) , xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Conditional Average Treatment Effect")  yscale(titlegap(*5)) ylab(, nogrid format(%03.1f) notick) xlab(, nogrid format(%03.1f) notick) title("`gtitle'") graphregion(color(white)) legend(order( 3 "90% CI"  2 "95% CI" 1 "99% CI") row(1) colfirst region(color(white))) name(G`istrat', replace) 
}
}

if ("`gsave'" != ""){
graph save "`gsave'`istrat'", replace
}
}

if ("`oblinder'" == ""){
//Create Prediction Graphs
*CF Scatter
if strpos("`prediction'", "scatter") > 0 {
twoway (scatter `CF_T_`depvar'' `gxinput_Pred', mcolor(navy%40) msymbol(O)) (scatter `CF_C_`depvar'' `gxinput_Pred', mcolor(maroon%40) msymbol(O)) if abs(`running') <= `bandwidth' `ifstatement' & `x' != ., title("`gtitle'") xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Predicted: `YLabel_Pred'")  yscale(titlegap(*7) ) ylab(, nogrid notick) xlab(, nogrid notick ) graphregion(color(white)) legend(order(2 "Control" 1 "Treated")  row(1) colfirst region(color(white))) name(GPred1`istrat', replace) 
}
*CF Line and CIs
if strpos("`prediction'", "line") > 0 {
twoway (rarea `CFLCI_T_`depvar'' `CFUCI_T_`depvar'' `gxinput_Pred', bcolor(navy%80)) (rarea `CFLCI_C_`depvar'' `CFUCI_C_`depvar'' `gxinput_Pred', bcolor(maroon%80))  (line `CF_T_`depvar'' `gxinput_Pred', mcolor(navy%40) lcolor(navy) msymbol(O) connect(direct)) (line `CF_C_`depvar'' `gxinput_Pred', mcolor(maroon%40) lcolor(maroon) msymbol(O)) , title("`gtitle'") xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Predicted: `YLabel_Pred'")  yscale(titlegap(*7) ) ylab(, nogrid notick) xlab(, nogrid notick ) graphregion(color(white)) legend(order(2 "Control" 1 "Treated")  row(1) colfirst region(color(white))) name(GPred2`istrat', replace) 
}
*Actual Predictions
if strpos("`prediction'", "actual") > 0 {
twoway (scatter `Predict_`depvar'' `gxinput_Pred' if `treatvar' == 1 , mcolor(navy%40) msymbol(O)) (scatter `Predict_`depvar'' `gxinput_Pred' if `treatvar' == 0, mcolor(maroon%40) msymbol(O)) if abs(`running') <= `bandwidth' `ifstatement' & `x' != ., title("`gtitle'") xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Predicted: `YLabel_Pred'")  yscale(titlegap(*7) ) ylab(, nogrid notick) xlab(, nogrid notick ) graphregion(color(white)) legend(order(2 "Control" 1 "Treated")  row(1) colfirst region(color(white))) name(GPred3`istrat', replace) 
}

*Both Predictions
if strpos("`prediction'", "both") > 0 {
twoway  (scatter `CF_T_`depvar'' `gxinput_Pred', mcolor(navy%30) msymbol(O)) (scatter `CF_C_`depvar'' `gxinput_Pred', mcolor(maroon%30)) (rarea `MeanCFLCI_T' `MeanCFUCI_T' `gxinput_Pred', bcolor(navy%70)) (rarea `MeanCFLCI_C' `MeanCFUCI_C' `gxinput_Pred', bcolor(maroon%70))  (line `MeanCF_T' `gxinput_Pred', mcolor(navy%40) lcolor(navy) msymbol(O) connect(direct)) (line `MeanCF_C' `gxinput_Pred', mcolor(maroon%40) lcolor(maroon) msymbol(O)) , title("`gtitle'") xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Predicted: `YLabel_Pred'")  yscale(titlegap(*7) ) ylab(, nogrid notick) xlab(, nogrid notick ) graphregion(color(white)) legend(order(2 "Control" 1 "Treated")  row(1) colfirst region(color(white))) name(GPred4`istrat', replace) 
}


if ("`gsave'" != ""){
graph save "Pred_`gsave'`istrat'", replace
}
}

if ("`oblinder'" != ""){
  svmat `OBResults' , name(`OBQSummary')
   
  *twoway (line Total_B IPW_EQuantile) (line Endowment_B IPW_EQuantile) (line Coefficient_B IPW_EQuantile) (line Unexplained_B IPW_EQuantile) (scatteri 0 0 0 1, recast(line) lcolor(black) lpattern(dash)) , xtitle("`XLabel' Quantile") xscale(titlegap(*3)) ytitle("Conditional Treatment Effect")  yscale(titlegap(*5)) ylab(, nogrid format(%03.1f) notick) xlab(, nogrid format(%03.1f) notick) graphregion(color(white)) 

    //Create A Set of Matricies of Betas, SEs and P-Values for the OB Decomposition, with only the variables we are interested in
    matrix Beta_OB = `Results'[1...,2]
    matrix SE_OB = `Results'[1...,2]
    matrix PVal_OB = `Results'[1...,2]

    foreach z of local totaldecompnames{
    matrix Beta_OB = [Beta_OB, Beta_Matrix[1...,"`z'"]]
    matrix SE_OB = [SE_OB, SE_Matrix[1...,"`z'"]]
    matrix PVal_OB = [PVal_OB, PVal_Matrix[1...,"`z'"]]
	}
	
	matrix Beta_OB = Beta_OB[1...,2...]
  	matrix SE_OB = SE_OB[1...,2...]
	matrix PVal_OB = PVal_OB[1...,2...]
	
	
	tempname Beta_OB SE_OB PVal_OB
	svmat Beta_OB , name(`Beta_OB')
	svmat SE_OB , name(`SE_OB')
	svmat PVal_OB , name(`PVal_OB')
	

    local Colours = "maroon forest_green dkorange teal cranberry lavender khaki sienna emidblue emerald brown erose gold bluishgray"
	
		if (`gminx' != 1 | `gmaxx' != 0) {
			local GraphCall = "(line `OBQSummary'1 `gxinput' if `gxinput' > `gminx' & `gxinput' < `gmaxx')  (rarea `IPW_LBB' `IPW_UBB' `gxinput' if `gxinput' > `gminx' & `gxinput' < `gmaxx', bcolor(navy%25) alwidth(0))"
		}
		if (`gminx' == 1 & `gmaxx' == 0) {
				local GraphCall = "(line `OBQSummary'1 `gxinput')  (rarea `IPW_LBB' `IPW_UBB' `gxinput', bcolor(navy%25) alwidth(0))"
		}

	local NameCount: word count `totaldecompnames'  
    local LegendNames =  `"1 "Total Effect" "' //Create Input for Legend which, below, includes all names of significant components
	local TempCount = 1
	local TempCount2 = 0

	forvalues i = 1(1)`NameCount' {
	quietly sum `PVal_OB'`i', detail 
	
	*if (r(p`obcutoff') > 0.1) { //P-value is significant at the 10% level for the obcutoff percentile
	if (r(mean) > `obcutoff') { //Mean of P-value is above obcutoff
	drop `Beta_OB'`i'
	drop `SE_OB'`i'
	drop `PVal_OB'`i'
	}
	*if (r(p`obcutoff') <= 0.1) {
	if (r(mean) <= `obcutoff') {
	local TempCount = `TempCount' + 2
	local TempCount2 = `TempCount2' + 1

	*Create Legend Labels for Graph
	local Temp_Colname: word `i' of `totaldecompnames'
	local Temp_ColnameUn =  strpos("`Temp_Colname'" , "Unexplained:") > 0
	local Temp_ColnameEx =  strpos("`Temp_Colname'" , "Explained:") > 0
	local Temp_Colname = subinstr("`Temp_Colname'" , "Unexplained:" , "" , .)
	local Temp_Colname = subinstr("`Temp_Colname'" , "Explained:" , "" , .)	

	if "`Temp_Colname'" != "_cons" { 
		local Temp_Colname : var label `Temp_Colname'
		if missing("`Temp_Colname'") {
			local Temp_Colname = "`Temp_Colname'"
		}
	}
	
	if "`Temp_Colname'" == "_cons" { 
	local Temp_Colname = "Constant"
	}
	
	if "`Temp_ColnameUn'" == "1" {
	local Temp_Colname = "`Temp_Colname'" + " [C]"
	}
	if "`Temp_ColnameEx'" == "1" {
	local Temp_Colname = "`Temp_Colname'" + " [E]"
	}
		
	local Temp_Colour: word `TempCount2' of `Colours'
	local LegendNames = `"`LegendNames'"' + `"`TempCount' "`Temp_Colname'" "'
	
	tempname OB_UB OB_LB
	quietly gen `OB_UB'`i' = `Beta_OB'`i' - (1.96 * `SE_OB'`i') //Create 5% Confidence intervals
    quietly gen `OB_LB'`i' = `Beta_OB'`i' + (1.96 * `SE_OB'`i')
	
		if (`gminx' != 1 | `gmaxx' != 0) {
			local GraphCall = "`GraphCall' " + "(line `Beta_OB'`i' `gxinput'  if `gxinput' > `gminx' & `gxinput' < `gmaxx', color(`Temp_Colour'))  (rarea `OB_LB'`i' `OB_UB'`i' `gxinput'  if `gxinput' > `gminx' & `gxinput' < `gmaxx', bcolor(`Temp_Colour'%25) alwidth(0))"
		}
		if (`gminx' == 1 & `gmaxx' == 0) {
			local GraphCall = "`GraphCall' " + "(line `Beta_OB'`i' `gxinput', color(`Temp_Colour'))  (rarea `OB_LB'`i' `OB_UB'`i' `gxinput', bcolor(`Temp_Colour'%25) alwidth(0))"
		}
	}
    }
	
	
    twoway `GraphCall' (scatteri 0 `TempGxmin' 0 `TempGxmax', recast(line) lcolor(black) lpattern(dash)) , xtitle("`XLabel'") xscale(titlegap(*3)) ytitle("Conditional Average Treatment Effect")  yscale(titlegap(*5)) ylab(, nogrid format(%03.1f) notick) xlab(, nogrid format(%03.1f) notick) graphregion(color(white)) title("`gtitle'") legend(order(`"`LegendNames'"') region(color(white))) name(GOB`istrat', replace) 

if ("`gsave'" != ""){
graph save "`gsave'`istrat'", replace
}
}

}

quietly{

	//Restore Full Dataset
    tempvar _merge
	merge 1:1 `TempUniqueID' using `TemporaryData' , gen(`_merge')
}

} //iStrat End


/////////// Return /////////////////////////////////////////////////////////////
return matrix Summary = `Results' 
if ("`oblinder'" == ""){
return matrix Coefs = Beta_Matrix
return matrix SE = SE_Matrix
return matrix PVal = PVal_Matrix
return scalar RSS = `RSS'
return scalar TSS = `TSS'
return scalar RSq = `RSq'
return scalar ACATE = `ACATE'
return scalar ACATET = `ACATET'
}

if ("`oblinder'" != ""){
return matrix OBSummary = `OBResults'
return matrix Coefs = Beta_OB
return matrix SE = SE_OB
return matrix PVal = PVal_OB
}

//Output Variables
capture drop CATE_`depvar'
qui gen CATE_`depvar' = `CATE_`depvar''
capture drop Ave_`x'_Quantile
qui gen Ave_`x'_Quantile = `Ave_`x'_Quantile'

//Drop 
capture drop LL_`x'

////////// Graphing ///////////////////////////////////////////////////////////



 end


//Improvements: 
*Issue with bsweight and bs4rw is that the weights cannot be calculated with an if, so we have to drop all variables which would not be included in the regression.. but by saving temporary .dta files and then merging we don't lose anything...
